import { useState, useEffect } from 'react'
import { Box, Typography, Button } from '@mui/material'
import ReimbursementForm from '../components/ReimbursementForm'
import ReimbursementList from '../components/ReimbursementList'

const Reimbursements = () => {
  const [reimbursements, setReimbursements] = useState([])
  const [showForm, setShowForm] = useState(false)

  const handleSubmit = (newReimbursement) => {
    setReimbursements([...reimbursements, { 
      ...newReimbursement, 
      id: Date.now(),
      status: 'pending',
      submissionDate: new Date().toISOString()
    }])
    setShowForm(false)
  }

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom color="primary">
        Reimbursements
      </Typography>
      {!showForm ? (
        <Button 
          variant="contained" 
          onClick={() => setShowForm(true)}
          sx={{ mb: 3 }}
        >
          Submit New Reimbursement
        </Button>
      ) : (
        <ReimbursementForm onSubmit={handleSubmit} />
      )}
      <ReimbursementList reimbursements={reimbursements} />
    </Box>
  )
}

export default Reimbursements
