export default function Contact() {
  return (
    <div className="container">
      <h1>Contact Us</h1>
      <section>
        <h2>Office Information</h2>
        <p>123 Medical Center Drive</p>
        <p>City, State 12345</p>
        <p>Phone: (123) 456-7890</p>
        <p>Email: info@clinicaloffice.com</p>
      </section>
      <section>
        <h2>Office Hours</h2>
        <p>Monday - Friday: 8:00 AM - 5:00 PM</p>
        <p>Saturday: 9:00 AM - 1:00 PM</p>
        <p>Sunday: Closed</p>
      </section>
      <form className="contact-form">
        <h2>Send Us a Message</h2>
        <div>
          <label htmlFor="name">Name:</label>
          <input type="text" id="name" name="name" required />
        </div>
        <div>
          <label htmlFor="email">Email:</label>
          <input type="email" id="email" name="email" required />
        </div>
        <div>
          <label htmlFor="message">Message:</label>
          <textarea id="message" name="message" rows="5" required></textarea>
        </div>
        <button type="submit" className="button">Send Message</button>
      </form>
    </div>
  )
}
