import { useState, useEffect } from 'react'
import { FaQuoteLeft, FaChevronLeft, FaChevronRight } from 'react-icons/fa'

export default function App() {
  const [currentOfferIndex, setCurrentOfferIndex] = useState(0)
  const [currentTestimonialIndex, setCurrentTestimonialIndex] = useState(0)

  const offers = [
    {
      title: "Early Bird Special",
      description: "Get 20% off all donations made before the event day!",
      validUntil: "Offer valid until October 15th"
    },
    {
      title: "Corporate Matching",
      description: "Many companies will match your donation - ask your employer!",
      validUntil: "Available year-round"
    },
    {
      title: "Double Impact Day",
      description: "All donations on event day will be matched by our sponsors!",
      validUntil: "Only on October 20th"
    }
  ]

  const testimonials = [
    {
      quote: "Fundraiser Day helped us raise over $50,000 for local schools last year!",
      author: "Sarah Johnson, Education Foundation"
    },
    {
      quote: "The most well-organized fundraising event we've ever participated in.",
      author: "Michael Chen, Community Center"
    },
    {
      quote: "Our nonprofit gained dozens of new regular donors through this event.",
      author: "Lisa Rodriguez, Animal Shelter"
    }
  ]

  const companyInfo = {
    name: "Community Fundraisers Inc.",
    mission: "Connecting donors with worthy causes through impactful events",
    contact: "info@fundraiserday.org | (555) 123-4567",
    address: "123 Charity Lane, Philanthropy City, PC 98765"
  }

  // Auto-rotate offers every 5 seconds
  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentOfferIndex((prev) => (prev + 1) % offers.length)
    }, 5000)
    return () => clearInterval(interval)
  }, [])

  const nextOffer = () => {
    setCurrentOfferIndex((prev) => (prev + 1) % offers.length)
  }

  const prevOffer = () => {
    setCurrentOfferIndex((prev) => (prev - 1 + offers.length) % offers.length)
  }

  const nextTestimonial = () => {
    setCurrentTestimonialIndex((prev) => (prev + 1) % testimonials.length)
  }

  const prevTestimonial = () => {
    setCurrentTestimonialIndex((prev) => (prev - 1 + testimonials.length) % testimonials.length)
  }

  return (
    <div className="app">
      <header style={headerStyle}>
        <h1>Fundraiser Day</h1>
        <p>Join us on October 20th for our annual community fundraising event!</p>
      </header>

      <section style={sectionStyle}>
        <h2>About Fundraiser Day</h2>
        <p style={paragraphStyle}>
          Fundraiser Day brings together dozens of local nonprofits and thousands of donors for a day of giving.
          Since 2010, we've helped raise over $5 million for worthy causes in our community.
        </p>
        <p style={paragraphStyle}>
          This year's event will feature live entertainment, food trucks, and opportunities to meet with
          representatives from participating organizations.
        </p>
      </section>

      <section style={sectionStyle}>
        <h2>Current Offers</h2>
        <div style={carouselContainer}>
          <button onClick={prevOffer} style={navButtonStyle}>
            <FaChevronLeft />
          </button>
          <div style={offerCardStyle}>
            <h3>{offers[currentOfferIndex].title}</h3>
            <p>{offers[currentOfferIndex].description}</p>
            <p style={validUntilStyle}>{offers[currentOfferIndex].validUntil}</p>
          </div>
          <button onClick={nextOffer} style={navButtonStyle}>
            <FaChevronRight />
          </button>
        </div>
      </section>

      <section style={sectionStyle}>
        <h2>Testimonials</h2>
        <div style={testimonialContainer}>
          <button onClick={prevTestimonial} style={navButtonStyle}>
            <FaChevronLeft />
          </button>
          <div style={testimonialCardStyle}>
            <FaQuoteLeft style={quoteIconStyle} />
            <p style={quoteStyle}>{testimonials[currentTestimonialIndex].quote}</p>
            <p style={authorStyle}>— {testimonials[currentTestimonialIndex].author}</p>
          </div>
          <button onClick={nextTestimonial} style={navButtonStyle}>
            <FaChevronRight />
          </button>
        </div>
      </section>

      <section style={sectionStyle}>
        <h2>About Us</h2>
        <div style={companyInfoStyle}>
          <h3>{companyInfo.name}</h3>
          <p>{companyInfo.mission}</p>
          <p>{companyInfo.contact}</p>
          <p>{companyInfo.address}</p>
        </div>
      </section>

      <footer style={footerStyle}>
        <p>© {new Date().getFullYear()} Community Fundraisers Inc. All rights reserved.</p>
      </footer>
    </div>
  )
}

// Styles
const headerStyle = {
  backgroundColor: 'peru',
  color: 'white',
  padding: '2rem',
  textAlign: 'center'
}

const sectionStyle = {
  padding: '2rem',
  maxWidth: '800px',
  margin: '0 auto'
}

const paragraphStyle = {
  margin: '1rem 0',
  lineHeight: '1.6'
}

const carouselContainer = {
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  gap: '1rem',
  margin: '2rem 0'
}

const offerCardStyle = {
  backgroundColor: 'white',
  padding: '1.5rem',
  borderRadius: '8px',
  boxShadow: '0 2px 8px rgba(0,0,0,0.1)',
  width: '400px',
  minHeight: '200px',
  display: 'flex',
  flexDirection: 'column',
  justifyContent: 'center'
}

const validUntilStyle = {
  fontStyle: 'italic',
  color: 'peru',
  marginTop: '1rem'
}

const navButtonStyle = {
  backgroundColor: 'peru',
  color: 'white',
  border: 'none',
  borderRadius: '50%',
  width: '40px',
  height: '40px',
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  cursor: 'pointer',
  fontSize: '1.2rem'
}

const testimonialContainer = {
  display: 'flex',
  alignItems: 'center',
  justifyContent: 'center',
  gap: '1rem',
  margin: '2rem 0'
}

const testimonialCardStyle = {
  backgroundColor: 'white',
  padding: '2rem',
  borderRadius: '8px',
  boxShadow: '0 2px 8px rgba(0,0,0,0.1)',
  width: '500px',
  position: 'relative'
}

const quoteIconStyle = {
  color: 'peru',
  fontSize: '2rem',
  position: 'absolute',
  top: '10px',
  left: '10px'
}

const quoteStyle = {
  fontStyle: 'italic',
  margin: '1rem 0 1rem 2rem',
  lineHeight: '1.6'
}

const authorStyle = {
  fontWeight: 'bold',
  textAlign: 'right',
  color: 'peru'
}

const companyInfoStyle = {
  backgroundColor: 'white',
  padding: '1.5rem',
  borderRadius: '8px',
  boxShadow: '0 2px 8px rgba(0,0,0,0.1)'
}

const footerStyle = {
  backgroundColor: 'peru',
  color: 'white',
  textAlign: 'center',
  padding: '1rem',
  marginTop: '2rem'
}
