import { useState } from 'react'

export default function Booking() {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    phone: '',
    service: '',
    date: '',
    address: ''
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    alert('Booking submitted! We will contact you shortly.')
    // Here you would typically send the data to your backend
  }

  return (
    <div className="booking">
      <h1>Book a Service</h1>
      <form className="booking-form" onSubmit={handleSubmit}>
        <label>
          Full Name:
          <input 
            type="text" 
            value={formData.name}
            onChange={(e) => setFormData({...formData, name: e.target.value})}
            required
          />
        </label>
        
        <label>
          Email:
          <input 
            type="email" 
            value={formData.email}
            onChange={(e) => setFormData({...formData, email: e.target.value})}
            required
          />
        </label>
        
        <label>
          Phone:
          <input 
            type="tel" 
            value={formData.phone}
            onChange={(e) => setFormData({...formData, phone: e.target.value})}
            required
          />
        </label>
        
        <label>
          Service:
          <select 
            value={formData.service}
            onChange={(e) => setFormData({...formData, service: e.target.value})}
            required
          >
            <option value="">Select a service</option>
            <option value="standard">Standard Cleaning</option>
            <option value="deep">Deep Cleaning</option>
            <option value="move">Move-In/Move-Out</option>
            <option value="recurring">Recurring Service</option>
          </select>
        </label>
        
        <label>
          Date:
          <input 
            type="date" 
            value={formData.date}
            onChange={(e) => setFormData({...formData, date: e.target.value})}
            required
          />
        </label>
        
        <label>
          Address:
          <textarea 
            value={formData.address}
            onChange={(e) => setFormData({...formData, address: e.target.value})}
            required
          />
        </label>
        
        <button type="submit" className="button">Book Now</button>
      </form>
    </div>
  )
}
