import { useState } from 'react'

export default function Contact() {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    message: ''
  })

  const handleSubmit = (e) => {
    e.preventDefault()
    alert('Message sent! We will get back to you soon.')
    // Here you would typically send the data to your backend
  }

  return (
    <div className="contact">
      <h1>Contact Us</h1>
      <div className="contact-info">
        <p>Phone: (555) 123-4567</p>
        <p>Email: info@cleanhome.com</p>
        <p>Address: 123 Cleaning St, Clean City, CC 12345</p>
      </div>
      
      <form className="contact-form" onSubmit={handleSubmit}>
        <label>
          Name:
          <input 
            type="text" 
            value={formData.name}
            onChange={(e) => setFormData({...formData, name: e.target.value})}
            required
          />
        </label>
        
        <label>
          Email:
          <input 
            type="email" 
            value={formData.email}
            onChange={(e) => setFormData({...formData, email: e.target.value})}
            required
          />
        </label>
        
        <label>
          Message:
          <textarea 
            value={formData.message}
            onChange={(e) => setFormData({...formData, message: e.target.value})}
            required
          />
        </label>
        
        <button type="submit" className="button">Send Message</button>
      </form>
    </div>
  )
}
