import { Link } from 'react-router-dom'
import { FaBars, FaTimes } from 'react-icons/fa'
import { useState } from 'react'

export default function Navbar() {
  const [isOpen, setIsOpen] = useState(false)

  return (
    <nav style={{ backgroundColor: '#b22222', color: 'white', padding: '1rem 0' }}>
      <div className="container">
        <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
          <Link to="/" style={{ color: 'white', fontSize: '1.5rem', fontWeight: 'bold' }}>
            TechSolutions Pro
          </Link>
          
          <div className="desktop-menu" style={{ display: { sm: 'none', md: 'flex' }, gap: '1.5rem' }}>
            <Link to="/about" style={{ color: 'white' }}>About</Link>
            <Link to="/services" style={{ color: 'white' }}>Services</Link>
            <Link to="/case-studies" style={{ color: 'white' }}>Case Studies</Link>
            <Link to="/news" style={{ color: 'white' }}>News</Link>
            <Link to="/contact" style={{ color: 'white' }}>Contact</Link>
          </div>

          <button 
            onClick={() => setIsOpen(!isOpen)} 
            style={{ 
              background: 'none', 
              border: 'none', 
              color: 'white', 
              fontSize: '1.5rem',
              display: { md: 'none' }
            }}
          >
            {isOpen ? <FaTimes /> : <FaBars />}
          </button>
        </div>

        {isOpen && (
          <div style={{ display: 'flex', flexDirection: 'column', gap: '1rem', marginTop: '1rem' }}>
            <Link to="/about" style={{ color: 'white' }}>About</Link>
            <Link to="/services" style={{ color: 'white' }}>Services</Link>
            <Link to="/case-studies" style={{ color: 'white' }}>Case Studies</Link>
            <Link to="/news" style={{ color: 'white' }}>News</Link>
            <Link to="/contact" style={{ color: 'white' }}>Contact</Link>
          </div>
        )}
      </div>
    </nav>
  )
}
