import { Link } from 'react-router-dom'
import { FaPhone, FaUser, FaShoppingCart } from 'react-icons/fa'

export default function Navbar() {
  return (
    <nav style={{ backgroundColor: 'olivedrab', padding: '1rem' }}>
      <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <Link to="/" style={{ color: 'white', textDecoration: 'none', fontSize: '1.5rem' }}>
          PhoneOperator
        </Link>
        <div style={{ display: 'flex', gap: '1rem' }}>
          <Link to="/plans" style={{ color: 'white', textDecoration: 'none' }}>
            <FaShoppingCart /> Plans
          </Link>
          <Link to="/support" style={{ color: 'white', textDecoration: 'none' }}>
            <FaPhone /> Support
          </Link>
          <Link to="/account" style={{ color: 'white', textDecoration: 'none' }}>
            <FaUser /> Account
          </Link>
        </div>
      </div>
    </nav>
  )
}
