import { useState } from 'react'

export default function Account() {
  const [user, setUser] = useState({
    name: 'John Doe',
    email: 'john@example.com',
    phone: '555-123-4567',
    plan: 'Standard'
  })

  const [editMode, setEditMode] = useState(false)

  const handleChange = (e) => {
    const { name, value } = e.target
    setUser(prev => ({ ...prev, [name]: value }))
  }

  const handleSave = () => {
    // In a real app, this would save to backend
    console.log('Updated user:', user)
    setEditMode(false)
  }

  return (
    <div>
      <h1>My Account</h1>
      <div style={{ 
        backgroundColor: 'darkolivegreen', 
        padding: '1rem', 
        borderRadius: '8px',
        maxWidth: '500px'
      }}>
        {editMode ? (
          <div>
            <div style={{ marginBottom: '1rem' }}>
              <label style={{ display: 'block', marginBottom: '0.5rem' }}>Name:</label>
              <input
                type="text"
                name="name"
                value={user.name}
                onChange={handleChange}
                style={{ width: '100%', padding: '0.5rem', borderRadius: '4px' }}
              />
            </div>
            <div style={{ marginBottom: '1rem' }}>
              <label style={{ display: 'block', marginBottom: '0.5rem' }}>Email:</label>
              <input
                type="email"
                name="email"
                value={user.email}
                onChange={handleChange}
                style={{ width: '100%', padding: '0.5rem', borderRadius: '4px' }}
              />
            </div>
            <div style={{ marginBottom: '1rem' }}>
              <label style={{ display: 'block', marginBottom: '0.5rem' }}>Phone:</label>
              <input
                type="tel"
                name="phone"
                value={user.phone}
                onChange={handleChange}
                style={{ width: '100%', padding: '0.5rem', borderRadius: '4px' }}
              />
            </div>
            <button 
              onClick={handleSave}
              style={{ 
                backgroundColor: 'goldenrod', 
                border: 'none', 
                padding: '0.5rem 1rem', 
                borderRadius: '4px',
                marginRight: '1rem'
              }}
            >
              Save
            </button>
            <button 
              onClick={() => setEditMode(false)}
              style={{ 
                backgroundColor: 'gray', 
                border: 'none', 
                padding: '0.5rem 1rem', 
                borderRadius: '4px'
              }}
            >
              Cancel
            </button>
          </div>
        ) : (
          <div>
            <p><strong>Name:</strong> {user.name}</p>
            <p><strong>Email:</strong> {user.email}</p>
            <p><strong>Phone:</strong> {user.phone}</p>
            <p><strong>Current Plan:</strong> {user.plan}</p>
            <button 
              onClick={() => setEditMode(true)}
              style={{ 
                backgroundColor: 'goldenrod', 
                border: 'none', 
                padding: '0.5rem 1rem', 
                borderRadius: '4px',
                marginTop: '1rem'
              }}
            >
              Edit Profile
            </button>
          </div>
        )}
      </div>
    </div>
  )
}
