import { useState } from 'react'

export default function Support() {
  const [message, setMessage] = useState('')
  const [submitted, setSubmitted] = useState(false)

  const handleSubmit = (e) => {
    e.preventDefault()
    // In a real app, this would send to a backend
    console.log('Support request:', message)
    setSubmitted(true)
    setMessage('')
    setTimeout(() => setSubmitted(false), 3000)
  }

  return (
    <div>
      <h1>Customer Support</h1>
      {submitted ? (
        <p style={{ color: 'gold' }}>Thank you! We'll contact you soon.</p>
      ) : (
        <form onSubmit={handleSubmit}>
          <div style={{ marginBottom: '1rem' }}>
            <label htmlFor="message" style={{ display: 'block', marginBottom: '0.5rem' }}>
              How can we help you?
            </label>
            <textarea
              id="message"
              value={message}
              onChange={(e) => setMessage(e.target.value)}
              style={{ 
                width: '100%', 
                padding: '0.5rem', 
                borderRadius: '4px',
                minHeight: '100px'
              }}
              required
            />
          </div>
          <button 
            type="submit"
            style={{ 
              backgroundColor: 'goldenrod', 
              border: 'none', 
              padding: '0.5rem 1rem', 
              borderRadius: '4px'
            }}
          >
            Submit Request
          </button>
        </form>
      )}
      <div style={{ marginTop: '2rem' }}>
        <h3>Contact Information</h3>
        <p>Phone: 1-800-555-OPERATOR</p>
        <p>Email: support@phoneoperator.com</p>
      </div>
    </div>
  )
}
