import React from 'react'
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts'

const ComparisonChart = ({ data }) => {
  return (
    <div className="p-4 rounded-lg shadow-md teal-border">
      <h2 className="text-xl font-semibold mb-4 teal-text">Company Comparison</h2>
      <div style={{ width: '100%', height: 400 }}>
        <ResponsiveContainer>
          <BarChart
            data={data}
            margin={{
              top: 5,
              right: 30,
              left: 20,
              bottom: 5,
            }}
          >
            <CartesianGrid strokeDasharray="3 3" />
            <XAxis dataKey="name" />
            <YAxis />
            <Tooltip />
            <Legend />
            <Bar dataKey="TechCorp" fill="#008080" name="Tech Corp" />
            <Bar dataKey="FinanceInc" fill="#006666" name="Finance Inc" />
            <Bar dataKey="RetailGroup" fill="#004d4d" name="Retail Group" />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  )
}

export default ComparisonChart
