import React from 'react'
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts'

const ConsolidatedChart = ({ data }) => {
  return (
    <div className="p-4 rounded-lg shadow-md teal-border">
      <h2 className="text-xl font-semibold mb-4 teal-text">Consolidated Performance</h2>
      <div style={{ width: '100%', height: 400 }}>
        <ResponsiveContainer>
          <BarChart
            data={data}
            margin={{
              top: 5,
              right: 30,
              left: 20,
              bottom: 5,
            }}
          >
            <CartesianGrid strokeDasharray="3 3" />
            <XAxis dataKey="name" />
            <YAxis />
            <Tooltip formatter={(value) => [`$${value.toLocaleString()}`, 'Amount']} />
            <Legend />
            <Bar dataKey="revenue" fill="#008080" name="Revenue" />
            <Bar dataKey="profit" fill="#004d4d" name="Profit" />
          </BarChart>
        </ResponsiveContainer>
      </div>
    </div>
  )
}

export default ConsolidatedChart
