import React from 'react'
import { useParams } from 'react-router-dom'
import FinancialChart from '../components/FinancialChart'
import CompanyInfo from '../components/CompanyInfo'

const CompanyDetail = () => {
  const { id } = useParams()
  // In a real app, this would come from an API
  const company = {
    id: 1,
    name: 'Tech Corp',
    revenue: 5000000,
    profit: 1200000,
    expenses: 3800000,
    employees: 250,
    founded: '2010',
    industry: 'Technology'
  }

  const financialData = [
    { name: 'Revenue', value: company.revenue },
    { name: 'Profit', value: company.profit },
    { name: 'Expenses', value: company.expenses }
  ]

  return (
    <div className="p-6">
      <h1 className="text-3xl font-bold mb-6 teal-text">{company.name}</h1>
      
      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        <CompanyInfo company={company} />
        <FinancialChart data={financialData} />
      </div>
    </div>
  )
}

export default CompanyDetail
