import React from 'react'
import { useNavigate } from 'react-router-dom'
import FinancialSummary from '../components/FinancialSummary'
import RecentActivities from '../components/RecentActivities'
import QuickActions from '../components/QuickActions'

const Dashboard = () => {
  const navigate = useNavigate()
  const companies = [
    { id: 1, name: 'Tech Corp', revenue: 5000000, profit: 1200000 },
    { id: 2, name: 'Finance Inc', revenue: 3000000, profit: 800000 },
    { id: 3, name: 'Retail Group', revenue: 2500000, profit: 600000 }
  ]

  return (
    <div className="p-6">
      <h1 className="text-3xl font-bold mb-6 teal-text">Company Dashboard</h1>
      
      <QuickActions />
      
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        {companies.map(company => (
          <div 
            key={company.id} 
            className="p-4 rounded-lg shadow-md teal-border cursor-pointer hover:bg-teal-50"
            onClick={() => navigate(`/company/${company.id}`)}
          >
            <h2 className="text-xl font-semibold teal-text">{company.name}</h2>
            <p>Revenue: ${company.revenue.toLocaleString()}</p>
            <p>Profit: ${company.profit.toLocaleString()}</p>
          </div>
        ))}
      </div>
      
      <FinancialSummary companies={companies} />
      <RecentActivities />
    </div>
  )
}

export default Dashboard
