import { Box, Typography } from '@mui/material'
import { PieChart, Pie, Cell, Tooltip, Legend, ResponsiveContainer } from 'recharts'

const COLORS = ['#0088FE', '#00C49F', '#FFBB28', '#FF8042']

export default function ClaimAnalysis() {
  // Sample data - would be replaced with real data from API
  const data = [
    { name: 'Approved', value: 400 },
    { name: 'Pending', value: 300 },
    { name: 'Rejected', value: 200 },
    { name: 'Under Review', value: 100 },
  ]

  return (
    <Box sx={{ height: 400 }}>
      <Typography variant="h6" gutterBottom>
        Claims Status
      </Typography>
      <ResponsiveContainer width="100%" height="100%">
        <PieChart>
          <Pie
            data={data}
            cx="50%"
            cy="50%"
            labelLine={false}
            outerRadius={80}
            fill="#8884d8"
            dataKey="value"
            label={({ name, percent }) => `${name}: ${(percent * 100).toFixed(0)}%`}
          >
            {data.map((entry, index) => (
              <Cell key={`cell-${index}`} fill={COLORS[index % COLORS.length]} />
            ))}
          </Pie>
          <Tooltip />
          <Legend />
        </PieChart>
      </ResponsiveContainer>
    </Box>
  )
}
