import { Routes, Route } from 'react-router-dom'
import ForumLayout from './components/ForumLayout'
import Home from './pages/Home'
import PostDetail from './pages/PostDetail'
import NewPost from './pages/NewPost'
import UserCenter from './pages/UserCenter'
import Category from './pages/Category'
import SearchResults from './pages/SearchResults'

function App() {
  return (
    <Routes>
      <Route path="/" element={<ForumLayout />}>
        <Route index element={<Home />} />
        <Route path="post/:id" element={<PostDetail />} />
        <Route path="new-post" element={<NewPost />} />
        <Route path="user-center" element={<UserCenter />} />
        <Route path="category/:name" element={<Category />} />
        <Route path="search" element={<SearchResults />} />
      </Route>
    </Routes>
  )
}

export default App
