import { Link, useNavigate } from 'react-router-dom'
import { useState } from 'react'

const Navbar = () => {
  const [searchQuery, setSearchQuery] = useState('')
  const navigate = useNavigate()

  const handleSearch = (e) => {
    e.preventDefault()
    if (searchQuery.trim()) {
      navigate(`/search?q=${encodeURIComponent(searchQuery)}`)
    }
  }

  return (
    <nav style={{ 
      backgroundColor: 'slategray', 
      padding: '10px 20px',
      display: 'flex',
      justifyContent: 'space-between',
      alignItems: 'center'
    }}>
      <div style={{ display: 'flex', gap: '20px' }}>
        <Link to="/" style={{ color: 'white', fontWeight: 'bold' }}>Home</Link>
        <Link to="/category/general" style={{ color: 'white' }}>General</Link>
        <Link to="/category/tech" style={{ color: 'white' }}>Tech</Link>
        <Link to="/category/sports" style={{ color: 'white' }}>Sports</Link>
      </div>
      <form onSubmit={handleSearch} style={{ display: 'flex', gap: '10px' }}>
        <input
          type="text"
          placeholder="Search posts..."
          value={searchQuery}
          onChange={(e) => setSearchQuery(e.target.value)}
          style={{ padding: '5px', borderRadius: '4px', border: 'none' }}
        />
        <button 
          type="submit"
          style={{ 
            backgroundColor: 'white',
            color: 'slategray',
            border: 'none',
            borderRadius: '4px',
            padding: '5px 10px'
          }}
        >
          Search
        </button>
      </form>
      <Link to="/user-center" style={{ color: 'white' }}>User Center</Link>
    </nav>
  )
}

export default Navbar
