import { useState } from 'react'

const ReplyForm = ({ postId }) => {
  const [content, setContent] = useState('')

  const handleSubmit = (e) => {
    e.preventDefault()
    if (content.trim()) {
      // TODO: Connect to backend
      console.log('Replying to post', postId, 'with content:', content)
      setContent('')
    }
  }

  return (
    <form onSubmit={handleSubmit} style={{ marginBottom: '20px' }}>
      <textarea
        value={content}
        onChange={(e) => setContent(e.target.value)}
        placeholder="Write your reply..."
        style={{
          width: '100%',
          padding: '10px',
          borderRadius: '4px',
          border: '1px solid slategray',
          minHeight: '100px',
          marginBottom: '10px'
        }}
      />
      <button
        type="submit"
        style={{
          backgroundColor: 'slategray',
          color: 'white',
          border: 'none',
          padding: '8px 16px',
          borderRadius: '4px'
        }}
      >
        Post Reply
      </button>
    </form>
  )
}

export default ReplyForm
