import { useParams } from 'react-router-dom'
import PostCard from '../components/PostCard'
import { mockPosts } from '../data/mockData'

const Category = () => {
  const { name } = useParams()
  const categoryPosts = mockPosts.filter(post => post.category === name)

  return (
    <div style={{ maxWidth: '1000px', margin: '0 auto' }}>
      <h2 style={{ color: 'slategray', textTransform: 'capitalize' }}>{name} Posts</h2>
      {categoryPosts.length > 0 ? (
        <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
          {categoryPosts.map(post => (
            <PostCard key={post.id} post={post} />
          ))}
        </div>
      ) : (
        <p>No posts found in this category.</p>
      )}
    </div>
  )
}

export default Category
