import { Link } from 'react-router-dom'
import PostCard from '../components/PostCard'
import { mockPosts } from '../data/mockData'

const Home = () => {
  return (
    <div style={{ maxWidth: '1000px', margin: '0 auto' }}>
      <div style={{ 
        display: 'flex', 
        justifyContent: 'space-between', 
        alignItems: 'center',
        marginBottom: '20px'
      }}>
        <h2 style={{ color: 'slategray' }}>Recent Posts</h2>
        <Link 
          to="/new-post"
          style={{
            backgroundColor: 'slategray',
            color: 'white',
            padding: '8px 16px',
            borderRadius: '4px'
          }}
        >
          New Post
        </Link>
      </div>
      <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
        {mockPosts.map(post => (
          <PostCard key={post.id} post={post} />
        ))}
      </div>
    </div>
  )
}

export default Home
