import { useState } from 'react'
import { useNavigate } from 'react-router-dom'

const NewPost = () => {
  const [title, setTitle] = useState('')
  const [content, setContent] = useState('')
  const [category, setCategory] = useState('general')
  const navigate = useNavigate()

  const handleSubmit = (e) => {
    e.preventDefault()
    if (title.trim() && content.trim()) {
      // TODO: Connect to backend
      console.log('Creating new post:', { title, content, category })
      navigate('/')
    }
  }

  return (
    <div style={{ maxWidth: '800px', margin: '0 auto' }}>
      <h2 style={{ color: 'slategray' }}>Create New Post</h2>
      <form onSubmit={handleSubmit}>
        <div style={{ marginBottom: '15px' }}>
          <label style={{ display: 'block', marginBottom: '5px', color: 'slategray' }}>
            Title
          </label>
          <input
            type="text"
            value={title}
            onChange={(e) => setTitle(e.target.value)}
            style={{
              width: '100%',
              padding: '8px',
              borderRadius: '4px',
              border: '1px solid slategray'
            }}
            required
          />
        </div>
        
        <div style={{ marginBottom: '15px' }}>
          <label style={{ display: 'block', marginBottom: '5px', color: 'slategray' }}>
            Category
          </label>
          <select
            value={category}
            onChange={(e) => setCategory(e.target.value)}
            style={{
              width: '100%',
              padding: '8px',
              borderRadius: '4px',
              border: '1px solid slategray',
              backgroundColor: 'white'
            }}
          >
            <option value="general">General</option>
            <option value="tech">Tech</option>
            <option value="sports">Sports</option>
          </select>
        </div>
        
        <div style={{ marginBottom: '15px' }}>
          <label style={{ display: 'block', marginBottom: '5px', color: 'slategray' }}>
            Content
          </label>
          <textarea
            value={content}
            onChange={(e) => setContent(e.target.value)}
            style={{
              width: '100%',
              padding: '8px',
              borderRadius: '4px',
              border: '1px solid slategray',
              minHeight: '200px'
            }}
            required
          />
        </div>
        
        <button
          type="submit"
          style={{
            backgroundColor: 'slategray',
            color: 'white',
            border: 'none',
            padding: '10px 20px',
            borderRadius: '4px',
            cursor: 'pointer'
          }}
        >
          Create Post
        </button>
      </form>
    </div>
  )
}

export default NewPost
