import { mockUser, mockPosts, mockReplies } from '../data/mockData'

const UserCenter = () => {
  const userPosts = mockPosts.filter(post => mockUser.posts.includes(post.id))
  const userReplies = mockReplies.filter(reply => mockUser.replies.includes(reply.id))

  return (
    <div style={{ maxWidth: '1000px', margin: '0 auto' }}>
      <h2 style={{ color: 'slategray' }}>User Center</h2>
      
      <div style={{ marginBottom: '30px' }}>
        <h3 style={{ color: 'slategray' }}>My Information</h3>
        <div style={{ 
          backgroundColor: 'white',
          border: '1px solid slategray',
          padding: '15px',
          borderRadius: '8px'
        }}>
          <p><strong>Username:</strong> {mockUser.username}</p>
          <p><strong>Email:</strong> {mockUser.email}</p>
        </div>
      </div>
      
      <div style={{ marginBottom: '30px' }}>
        <h3 style={{ color: 'slategray' }}>My Posts ({userPosts.length})</h3>
        {userPosts.length > 0 ? (
          <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
            {userPosts.map(post => (
              <div 
                key={post.id}
                style={{ 
                  backgroundColor: 'slategray',
                  color: 'white',
                  padding: '15px',
                  borderRadius: '8px'
                }}
              >
                <h4 style={{ margin: '0 0 10px 0' }}>{post.title}</h4>
                <p style={{ margin: '5px 0' }}>{post.content.substring(0, 100)}...</p>
              </div>
            ))}
          </div>
        ) : (
          <p>You haven't created any posts yet.</p>
        )}
      </div>
      
      <div>
        <h3 style={{ color: 'slategray' }}>My Replies ({userReplies.length})</h3>
        {userReplies.length > 0 ? (
          <div style={{ display: 'flex', flexDirection: 'column', gap: '15px' }}>
            {userReplies.map(reply => (
              <div 
                key={reply.id}
                style={{ 
                  backgroundColor: 'white',
                  border: '1px solid slategray',
                  padding: '15px',
                  borderRadius: '8px'
                }}
              >
                <p style={{ margin: '0 0 10px 0', fontStyle: 'italic' }}>
                  Reply to post #{reply.postId}
                </p>
                <p style={{ margin: 0 }}>{reply.content}</p>
              </div>
            ))}
          </div>
        ) : (
          <p>You haven't replied to any posts yet.</p>
        )}
      </div>
    </div>
  )
}

export default UserCenter
