import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import { ThemeProvider, createTheme } from '@mui/material/styles'
import CssBaseline from '@mui/material/CssBaseline'
import Home from './pages/Home'
import Post from './pages/Post'
import CreatePost from './pages/CreatePost'
import Navbar from './components/Navbar'

const theme = createTheme({
  palette: {
    background: {
      default: '#F0FFF0', // honeydew
      paper: '#556B2F' // dark olive green
    },
    primary: {
      main: '#556B2F' // dark olive green
    },
    secondary: {
      main: '#F0FFF0' // honeydew
    },
    text: {
      primary: '#000000',
      secondary: '#F0FFF0'
    }
  }
})

function App() {
  return (
    <ThemeProvider theme={theme}>
      <CssBaseline />
      <Router>
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/post/:id" element={<Post />} />
          <Route path="/create" element={<CreatePost />} />
        </Routes>
      </Router>
    </ThemeProvider>
  )
}

export default App
