import './globals.css'

export const metadata = {
  title: 'Truth Expose',
  description: 'Whistleblower platform for exposing truths',
}

export default function RootLayout({ children }) {
  return (
    <html lang="en">
      <body className="bg-background min-h-screen">
        <header className="bg-primary text-white p-4 shadow-md">
          <div className="container mx-auto flex justify-between items-center">
            <h1 className="text-2xl font-bold">Truth Expose</h1>
            <nav>
              <ul className="flex space-x-6">
                <li><a href="/" className="hover:underline">Home</a></li>
                <li><a href="/report" className="hover:underline">Report</a></li>
                <li><a href="/forum" className="hover:underline">Forum</a></li>
                <li><a href="/news" className="hover:underline">News</a></li>
                <li><a href="/search" className="hover:underline">Search</a></li>
              </ul>
            </nav>
          </div>
        </header>
        <main className="container mx-auto p-4">
          {children}
        </main>
        <footer className="bg-primary text-white p-4 mt-8">
          <div className="container mx-auto text-center">
            <p>© {new Date().getFullYear()} Truth Expose - Protecting Whistleblowers</p>
          </div>
        </footer>
      </body>
    </html>
  )
}
