'use client'
import { useState } from 'react'
import { useRouter } from 'next/navigation'

export default function ReportPage() {
  const [title, setTitle] = useState('')
  const [content, setContent] = useState('')
  const [files, setFiles] = useState([])
  const [isSubmitting, setIsSubmitting] = useState(false)
  const router = useRouter()

  const handleSubmit = async (e) => {
    e.preventDefault()
    setIsSubmitting(true)
    
    try {
      const formData = new FormData()
      formData.append('title', title)
      formData.append('content', content)
      files.forEach(file => formData.append('files', file))
      
      const response = await fetch('/api/reports', {
        method: 'POST',
        body: formData
      })
      
      if (response.ok) {
        router.push('/thank-you')
      }
    } catch (error) {
      console.error('Submission error:', error)
    } finally {
      setIsSubmitting(false)
    }
  }

  return (
    <div className="max-w-2xl mx-auto bg-white p-6 rounded-lg shadow-md">
      <h2 className="text-xl font-semibold mb-4 text-primary">Anonymous Report</h2>
      <form onSubmit={handleSubmit}>
        <div className="mb-4">
          <label className="block text-gray-700 mb-2">Title</label>
          <input
            type="text"
            value={title}
            onChange={(e) => setTitle(e.target.value)}
            className="w-full p-2 border rounded"
            required
          />
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 mb-2">Details</label>
          <textarea
            value={content}
            onChange={(e) => setContent(e.target.value)}
            className="w-full p-2 border rounded h-40"
            required
          />
        </div>
        <div className="mb-4">
          <label className="block text-gray-700 mb-2">Evidence (optional)</label>
          <input
            type="file"
            multiple
            onChange={(e) => setFiles([...e.target.files])}
            className="w-full p-2 border rounded"
          />
        </div>
        <button
          type="submit"
          disabled={isSubmitting}
          className="bg-primary hover:bg-primary-dark text-white py-2 px-4 rounded disabled:opacity-50"
        >
          {isSubmitting ? 'Submitting...' : 'Submit Anonymously'}
        </button>
      </form>
    </div>
  )
}
