const express = require('express')
const sqlite3 = require('sqlite3').verbose()
const cors = require('cors')

const app = express()
app.use(cors())
app.use(express.json())

const db = new sqlite3.Database('./qa.db')

// Initialize database
db.serialize(() => {
  db.run(`
    CREATE TABLE IF NOT EXISTS questions (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      text TEXT NOT NULL,
      createdAt DATETIME DEFAULT CURRENT_TIMESTAMP
    )
  `)
  
  db.run(`
    CREATE TABLE IF NOT EXISTS answers (
      id INTEGER PRIMARY KEY AUTOINCREMENT,
      questionId INTEGER NOT NULL,
      text TEXT NOT NULL,
      rating INTEGER DEFAULT 0,
      createdAt DATETIME DEFAULT CURRENT_TIMESTAMP,
      FOREIGN KEY (questionId) REFERENCES questions(id)
    )
  `)
})

// Routes
app.get('/api/questions', (req, res) => {
  db.all('SELECT * FROM questions ORDER BY createdAt DESC', (err, rows) => {
    if (err) {
      res.status(500).json({ error: err.message })
      return
    }
    res.json(rows)
  })
})

app.post('/api/questions', (req, res) => {
  const { text } = req.body
  db.run('INSERT INTO questions (text) VALUES (?)', [text], function(err) {
    if (err) {
      res.status(500).json({ error: err.message })
      return
    }
    res.json({ id: this.lastID })
  })
})

app.get('/api/answers/:questionId', (req, res) => {
  const { questionId } = req.params
  db.all(
    'SELECT * FROM answers WHERE questionId = ? ORDER BY rating DESC, createdAt DESC', 
    [questionId], 
    (err, rows) => {
      if (err) {
        res.status(500).json({ error: err.message })
        return
      }
      res.json(rows)
    }
  )
})

app.post('/api/answers', (req, res) => {
  const { questionId, text } = req.body
  db.run(
    'INSERT INTO answers (questionId, text) VALUES (?, ?)',
    [questionId, text],
    function(err) {
      if (err) {
        res.status(500).json({ error: err.message })
        return
      }
      res.json({ id: this.lastID })
    }
  )
})

app.post('/api/answers/rate', (req, res) => {
  const { answerId, rating } = req.body
  db.run(
    'UPDATE answers SET rating = rating + ? WHERE id = ?',
    [rating, answerId],
    function(err) {
      if (err) {
        res.status(500).json({ error: err.message })
        return
      }
      res.json({ changes: this.changes })
    }
  )
})

const PORT = 3001
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})
