import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { useState, useEffect } from 'react';
import axios from 'axios';
import Navbar from './components/Navbar';
import Home from './pages/Home';
import Products from './pages/Products';
import Transactions from './pages/Transactions';
import SellerDashboard from './pages/SellerDashboard';
import DisputeResolution from './pages/DisputeResolution';

function App() {
  const [user, setUser] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    // Check if user is logged in
    const checkAuth = async () => {
      try {
        const response = await axios.get('/api/auth/check');
        setUser(response.data.user);
      } catch (error) {
        console.log('Not authenticated');
      } finally {
        setLoading(false);
      }
    };
    checkAuth();
  }, []);

  if (loading) return <div>Loading...</div>;

  return (
    <Router>
      <div className="App">
        <Navbar user={user} setUser={setUser} />
        <Routes>
          <Route path="/" element={<Home user={user} />} />
          <Route path="/products" element={<Products user={user} />} />
          <Route path="/transactions" element={<Transactions user={user} />} />
          <Route path="/seller" element={<SellerDashboard user={user} />} />
          <Route path="/disputes" element={<DisputeResolution user={user} />} />
        </Routes>
      </div>
    </Router>
  );
}

export default App;
