import { useState, useEffect } from 'react'
import { BrowserRouter, Routes, Route } from 'react-router-dom'
import Header from './components/Header'
import ProductSearch from './components/ProductSearch'
import ResultsPage from './components/ResultsPage'
import './App.css'

function App() {
  const [searchParams, setSearchParams] = useState(null)
  const [results, setResults] = useState([])

  return (
    <BrowserRouter>
      <div className="app">
        <Header />
        <Routes>
          <Route 
            path="/" 
            element={<ProductSearch setSearchParams={setSearchParams} />} 
          />
          <Route 
            path="/results" 
            element={<ResultsPage results={results} />} 
          />
        </Routes>
      </div>
    </BrowserRouter>
  )
}

export default App
