import { useState, useEffect } from 'react'
import { Container, TextField, Button, Grid, CircularProgress } from '@mui/material'
import DomainCard from '../components/DomainCard'
import api from '../services/api'

export default function DomainSearch() {
  const [searchTerm, setSearchTerm] = useState('')
  const [domains, setDomains] = useState([])
  const [loading, setLoading] = useState(false)

  const handleSearch = async () => {
    setLoading(true)
    try {
      const response = await api.get(`/domains?search=${searchTerm}`)
      setDomains(response.data)
    } catch (error) {
      console.error('Search error:', error)
    } finally {
      setLoading(false)
    }
  }

  return (
    <Container maxWidth="lg" sx={{ py: 4 }}>
      <TextField
        label="Search domains"
        variant="outlined"
        fullWidth
        value={searchTerm}
        onChange={(e) => setSearchTerm(e.target.value)}
        sx={{ mb: 3 }}
      />
      <Button
        variant="contained"
        color="primary"
        onClick={handleSearch}
        disabled={loading}
      >
        {loading ? <CircularProgress size={24} /> : 'Search'}
      </Button>

      <Grid container spacing={3} sx={{ mt: 3 }}>
        {domains.map((domain) => (
          <Grid item xs={12} sm={6} md={4} key={domain.id}>
            <DomainCard domain={domain} />
          </Grid>
        ))}
      </Grid>
    </Container>
  )
}
