import { Routes, Route } from 'react-router-dom'
import styled from 'styled-components'
import Navbar from './components/Navbar'
import Home from './pages/Home'
import Services from './pages/Services'
import Workshops from './pages/Workshops'
import Classes from './pages/Classes'
import Podcasts from './pages/Podcasts'
import Blog from './pages/Blog'
import Cart from './pages/Cart'
import Footer from './components/Footer'

const AppContainer = styled.div`
  min-height: 100vh;
  background-color: #e0ffff;
  display: flex;
  flex-direction: column;
`

function App() {
  return (
    <AppContainer>
      <Navbar />
      <Routes>
        <Route path="/" element={<Home />} />
        <Route path="/services" element={<Services />} />
        <Route path="/workshops" element={<Workshops />} />
        <Route path="/classes" element={<Classes />} />
        <Route path="/podcasts" element={<Podcasts />} />
        <Route path="/blog" element={<Blog />} />
        <Route path="/cart" element={<Cart />} />
      </Routes>
      <Footer />
    </AppContainer>
  )
}

export default App
