import styled from 'styled-components'
import { ServiceCard } from '../components'

const ServicesContainer = styled.div`
  padding: 2rem;
  flex: 1;
`

const ServicesGrid = styled.div`
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
  gap: 2rem;
  margin-top: 2rem;
`

export default function Services() {
  const services = [
    { id: 1, title: 'Executive Coaching', price: 299 },
    { id: 2, title: 'Team Leadership', price: 499 },
    { id: 3, title: 'Strategic Planning', price: 399 },
    { id: 4, title: 'Change Management', price: 599 },
  ]

  return (
    <ServicesContainer>
      <h1>Our Services</h1>
      <ServicesGrid>
        {services.map(service => (
          <ServiceCard key={service.id} service={service} />
        ))}
      </ServicesGrid>
    </ServicesContainer>
  )
}
