import { Bar } from 'react-chartjs-2'
import { Chart as ChartJS } from 'chart.js/auto'

export default function PolicyChart({ policyData }) {
  const data = {
    labels: policyData.labels,
    datasets: [
      {
        label: 'Policy Impact',
        data: policyData.values,
        backgroundColor: 'rgba(75, 0, 130, 0.6)', // indigo with opacity
        borderColor: 'rgba(75, 0, 130, 1)',
        borderWidth: 1
      }
    ]
  }

  return <Bar data={data} />
}
