import { useParams } from 'react-router-dom'
import { Box, Typography, Paper } from '@mui/material'
import PolicyChart from '../components/PolicyChart'
import { mockPolicies } from '../data/mockData'

export default function PolicyDetail() {
  const { id } = useParams()
  const policy = mockPolicies.find(p => p.id === id)

  if (!policy) return <Typography>Policy not found</Typography>

  return (
    <Box sx={{ p: 3 }}>
      <Typography variant="h3" gutterBottom>
        {policy.title}
      </Typography>
      
      <Paper sx={{ p: 3, mb: 3 }}>
        <Typography variant="body1" paragraph>
          {policy.description}
        </Typography>
        <Typography variant="subtitle1">
          Category: {policy.category}
        </Typography>
        <Typography variant="subtitle1">
          Effective Date: {policy.effectiveDate}
        </Typography>
      </Paper>

      <Paper sx={{ p: 3 }}>
        <Typography variant="h5" gutterBottom>
          Policy Impact Data
        </Typography>
        <PolicyChart policyData={policy.chartData} />
      </Paper>
    </Box>
  )
}
