import { useState } from 'react'
import '../App.css'

export default function TradingDashboard() {
  const [tradingItems, setTradingItems] = useState([
    { id: 1, name: 'Tech Stock', currentBid: 150.25 },
    { id: 2, name: 'Energy Shares', currentBid: 75.50 },
    { id: 3, name: 'Commodity ETF', currentBid: 42.75 }
  ])
  const [bidAmount, setBidAmount] = useState('')

  const placeBid = (itemId) => {
    const updatedItems = tradingItems.map(item => 
      item.id === itemId ? { ...item, currentBid: parseFloat(bidAmount) } : item
    )
    setTradingItems(updatedItems)
    setBidAmount('')
  }

  return (
    <div className="component">
      <h2>Trading Dashboard</h2>
      <div className="trading-items">
        {tradingItems.map(item => (
          <div key={item.id} className="trading-item">
            <h3>{item.name}</h3>
            <p>Current Bid: ${item.currentBid.toFixed(2)}</p>
            <input
              type="number"
              value={bidAmount}
              onChange={(e) => setBidAmount(e.target.value)}
              placeholder="Enter bid amount"
            />
            <button onClick={() => placeBid(item.id)}>Place Bid</button>
          </div>
        ))}
      </div>
    </div>
  )
}
