import { Box, Typography, List, ListItem, ListItemText, TextField, Button } from '@mui/material'
import { useState } from 'react'

export default function Recipients() {
  const { recipients, loading, error } = useRecipients()
  const [newRecipient, setNewRecipient] = useState({ name: '', email: '' })

  if (loading) return <Typography>Loading...</Typography>
  if (error) return <Typography color="error">{error}</Typography>

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>Recipients</Typography>
      <List>
        {recipients.map((recipient) => (
          <ListItem key={recipient.id}>
            <ListItemText
              primary={recipient.name}
              secondary={recipient.email}
            />
          </ListItem>
        ))}
      </List>
    </Box>
  )
}
