import { Box, Typography, List, ListItem, ListItemText } from '@mui/material'
import { useState, useEffect } from 'react'

export default function SentEmails() {
  const [sentEmails, setSentEmails] = useState([])

  useEffect(() => {
    const fetchSentEmails = async () => {
      const response = await fetch('/api/sent')
      const data = await response.json()
      setSentEmails(data)
    }

    fetchSentEmails()
  }, [])

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>Sent Emails</Typography>
      <List>
        {sentEmails.map((email) => (
          <ListItem key={email.id}>
            <ListItemText
              primary={email.subject}
              secondary={`To: ${email.to} - ${new Date(email.date).toLocaleString()}`}
            />
          </ListItem>
        ))}
      </List>
    </Box>
  )
}
