import { Box, Typography, List, ListItem, ListItemText, Button } from '@mui/material'
import { useState } from 'react'

export default function Templates() {
  const { templates, loading, error } = useTemplates()
  const [newTemplate, setNewTemplate] = useState({ name: '', content: '' })

  if (loading) return <Typography>Loading...</Typography>
  if (error) return <Typography color="error">{error}</Typography>

  return (
    <Box sx={{ p: 4 }}>
      <Typography variant="h4" gutterBottom>Email Templates</Typography>
      <List>
        {templates.map((template) => (
          <ListItem key={template.id}>
            <ListItemText
              primary={template.name}
              secondary={template.content.substring(0, 50) + '...'}
            />
          </ListItem>
        ))}
      </List>
    </Box>
  )
}
