import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Navbar from './components/Navbar'
import Home from './pages/Home'
import RegisterProduct from './pages/RegisterProduct'
import TrackProduct from './pages/TrackProduct'
import VerifyProduct from './pages/VerifyProduct'
import Analytics from './pages/Analytics'
import Footer from './components/Footer'

function App() {
  return (
    <Router>
      <Navbar />
      <div className="container">
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/register" element={<RegisterProduct />} />
          <Route path="/track" element={<TrackProduct />} />
          <Route path="/verify" element={<VerifyProduct />} />
          <Route path="/analytics" element={<Analytics />} />
        </Routes>
      </div>
      <Footer />
    </Router>
  )
}

export default App
