import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import Dashboard from './components/Dashboard'
import FinancialManagement from './components/FinancialManagement'
import Reports from './components/Reports'
import Pharmacy from './components/Pharmacy'
import Patients from './components/Patients'
import Laboratory from './components/Laboratory'
import Theater from './components/Theater'
import Navbar from './components/Navbar'

function App() {
  return (
    <Router>
      <div style={{ backgroundColor: 'peachpuff', minHeight: '100vh' }}>
        <Navbar />
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/financial" element={<FinancialManagement />} />
          <Route path="/reports" element={<Reports />} />
          <Route path="/pharmacy" element={<Pharmacy />} />
          <Route path="/patients" element={<Patients />} />
          <Route path="/laboratory" element={<Laboratory />} />
          <Route path="/theater" element={<Theater />} />
        </Routes>
      </div>
    </Router>
  )
}

export default App
