import { Link } from 'react-router-dom'
import styled from 'styled-components'

const Nav = styled.nav`
  background-color: #333;
  padding: 1rem;
  display: flex;
  gap: 1rem;
`

const NavLink = styled(Link)`
  color: white;
  text-decoration: none;
  &:hover {
    text-decoration: underline;
  }
`

export default function Navbar() {
  return (
    <Nav>
      <NavLink to="/">Home</NavLink>
      <NavLink to="/barbers">Barbers</NavLink>
      <NavLink to="/services">Services</NavLink>
      <NavLink to="/notifications">Notifications</NavLink>
    </Nav>
  )
}
