import { useState } from 'react'
import styled from 'styled-components'

const NotificationContainer = styled.div`
  padding: 2rem;
`

const Form = styled.form`
  display: flex;
  flex-direction: column;
  gap: 1rem;
  max-width: 500px;
`

const Input = styled.input`
  padding: 0.5rem;
  border-radius: 4px;
  border: none;
`

const TextArea = styled.textarea`
  padding: 0.5rem;
  border-radius: 4px;
  border: none;
  min-height: 100px;
`

const Button = styled.button`
  padding: 0.5rem 1rem;
  background-color: #4CAF50;
  color: white;
  border: none;
  border-radius: 4px;
  cursor: pointer;
`

export default function Notifications() {
  const [phone, setPhone] = useState('')
  const [message, setMessage] = useState('')

  const handleSendNotification = (e) => {
    e.preventDefault()
    const whatsappUrl = `https://wa.me/${phone}?text=${encodeURIComponent(message)}`
    window.open(whatsappUrl, '_blank')
    setPhone('')
    setMessage('')
  }

  return (
    <NotificationContainer>
      <h2>Send WhatsApp Notification</h2>
      <Form onSubmit={handleSendNotification}>
        <Input
          type="tel"
          placeholder="Client's phone number (with country code)"
          value={phone}
          onChange={(e) => setPhone(e.target.value)}
          required
        />
        <TextArea
          placeholder="Your message"
          value={message}
          onChange={(e) => setMessage(e.target.value)}
          required
        />
        <Button type="submit">Send Notification</Button>
      </Form>
    </NotificationContainer>
  )
}
