import { useState } from 'react'
import styled from 'styled-components'

const ServiceContainer = styled.div`
  padding: 2rem;
`

const ServiceList = styled.ul`
  list-style: none;
  padding: 0;
`

const ServiceItem = styled.li`
  background-color: #555;
  padding: 1rem;
  margin-bottom: 1rem;
  border-radius: 4px;
`

const Form = styled.form`
  display: flex;
  flex-direction: column;
  gap: 1rem;
  margin-top: 2rem;
`

const Input = styled.input`
  padding: 0.5rem;
  border-radius: 4px;
  border: none;
`

const Button = styled.button`
  padding: 0.5rem 1rem;
  background-color: #4CAF50;
  color: white;
  border: none;
  border-radius: 4px;
  cursor: pointer;
`

export default function Services() {
  const [services, setServices] = useState([
    { id: 1, name: 'Haircut', price: '$30', duration: '30 min' },
    { id: 2, name: 'Beard Trim', price: '$20', duration: '20 min' }
  ])
  const [newService, setNewService] = useState({ name: '', price: '', duration: '' })

  const handleAddService = (e) => {
    e.preventDefault()
    setServices([...services, { ...newService, id: Date.now() }])
    setNewService({ name: '', price: '', duration: '' })
  }

  return (
    <ServiceContainer>
      <h2>Our Services</h2>
      <ServiceList>
        {services.map(service => (
          <ServiceItem key={service.id}>
            <h3>{service.name}</h3>
            <p>Price: {service.price}</p>
            <p>Duration: {service.duration}</p>
          </ServiceItem>
        ))}
      </ServiceList>

      <h3>Add New Service</h3>
      <Form onSubmit={handleAddService}>
        <Input
          type="text"
          placeholder="Service name"
          value={newService.name}
          onChange={(e) => setNewService({ ...newService, name: e.target.value })}
          required
        />
        <Input
          type="text"
          placeholder="Price"
          value={newService.price}
          onChange={(e) => setNewService({ ...newService, price: e.target.value })}
          required
        />
        <Input
          type="text"
          placeholder="Duration"
          value={newService.duration}
          onChange={(e) => setNewService({ ...newService, duration: e.target.value })}
          required
        />
        <Button type="submit">Add Service</Button>
      </Form>
    </ServiceContainer>
  )
}
