const express = require('express')
const cors = require('cors')
const sqlite3 = require('sqlite3').verbose()
const bodyParser = require('body-parser')

const app = express()
app.use(cors())
app.use(bodyParser.json())

const db = new sqlite3.Database('./health-survey.db')

// Initialize database
db.serialize(() => {
  db.run(`CREATE TABLE IF NOT EXISTS surveys (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    age INTEGER,
    height REAL,
    weight REAL,
    medicalHistory TEXT,
    currentSymptoms TEXT,
    lifestyle TEXT,
    contactInfo TEXT,
    submittedAt DATETIME DEFAULT CURRENT_TIMESTAMP
  )`)
})

// Survey submission endpoint
app.post('/api/surveys', (req, res) => {
  const { age, height, weight, medicalHistory, currentSymptoms, lifestyle, contactInfo } = req.body
  db.run(
    `INSERT INTO surveys (age, height, weight, medicalHistory, currentSymptoms, lifestyle, contactInfo) 
     VALUES (?, ?, ?, ?, ?, ?, ?)`,
    [age, height, weight, medicalHistory, currentSymptoms, lifestyle, contactInfo],
    function(err) {
      if (err) {
        return res.status(500).json({ error: err.message })
      }
      res.status(201).json({ id: this.lastID })
    }
  )
})

// Get all surveys endpoint
app.get('/api/surveys', (req, res) => {
  db.all('SELECT * FROM surveys ORDER BY submittedAt DESC', [], (err, rows) => {
    if (err) {
      return res.status(500).json({ error: err.message })
    }
    res.json(rows)
  })
})

const PORT = process.env.PORT || 3001
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`)
})
