import { useState } from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom'
import SurveyForm from './components/SurveyForm'
import AdminDashboard from './components/AdminDashboard'
import Login from './components/Login'
import Navbar from './components/Navbar'
import './App.css'

function App() {
  const [user, setUser] = useState(null)

  return (
    <div className="app">
      <Router>
        <Navbar user={user} setUser={setUser} />
        <Routes>
          <Route path="/" element={<SurveyForm />} />
          <Route path="/login" element={<Login setUser={setUser} />} />
          <Route 
            path="/admin" 
            element={user ? <AdminDashboard /> : <Login setUser={setUser} />} 
          />
        </Routes>
      </Router>
    </div>
  )
}

export default App
