import { useState, useEffect } from 'react'
import axios from 'axios'

const AdminDashboard = () => {
  const [surveys, setSurveys] = useState([])
  const [loading, setLoading] = useState(true)

  useEffect(() => {
    const fetchSurveys = async () => {
      try {
        const response = await axios.get('http://localhost:3001/api/surveys')
        setSurveys(response.data)
        setLoading(false)
      } catch (error) {
        console.error('Error fetching surveys:', error)
      }
    }
    fetchSurveys()
  }, [])

  if (loading) return <div>Loading...</div>

  return (
    <div className="form-container">
      <h2>Survey Submissions</h2>
      <div className="survey-list">
        {surveys.map((survey, index) => (
          <div key={index} className="card">
            <h3>Survey #{index + 1}</h3>
            <p><strong>Age:</strong> {survey.age}</p>
            <p><strong>Height:</strong> {survey.height} cm</p>
            <p><strong>Weight:</strong> {survey.weight} kg</p>
            <p><strong>Medical History:</strong> {survey.medicalHistory}</p>
            <p><strong>Symptoms:</strong> {survey.currentSymptoms}</p>
            <p><strong>Lifestyle:</strong> {survey.lifestyle}</p>
            <p><strong>Contact:</strong> {survey.contactInfo}</p>
          </div>
        ))}
      </div>
    </div>
  )
}

export default AdminDashboard
