import { useState } from 'react'

export default function Jobs() {
  const [jobs, setJobs] = useState([
    { id: 1, title: 'Delivery Driver', company: 'ABC Logistics', location: 'New York' },
    { id: 2, title: 'Truck Driver', company: 'XYZ Transport', location: 'Chicago' },
  ])

  return (
    <div className="container mx-auto px-4 py-8">
      <div className="content-block">
        <h2 className="text-2xl font-bold mb-4">Available Jobs</h2>
        <div className="grid gap-4">
          {jobs.map(job => (
            <div key={job.id} className="bg-white text-navy p-4 rounded">
              <h3 className="text-xl font-semibold">{job.title}</h3>
              <p>{job.company} - {job.location}</p>
              <button className="btn-primary mt-2">Apply Now</button>
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}
