import { useState } from 'react'

export default function Register() {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    password: '',
    userType: 'driver'
  })

  const handleSubmit = async (e) => {
    e.preventDefault()
    // Submit to backend
  }

  return (
    <div className="container mx-auto px-4 py-8">
      <div className="content-block max-w-md mx-auto">
        <h2 className="text-2xl font-bold mb-4">Register</h2>
        <form onSubmit={handleSubmit}>
          <div className="mb-4">
            <label className="block mb-2">Name</label>
            <input 
              type="text" 
              className="w-full p-2 rounded text-black"
              value={formData.name}
              onChange={(e) => setFormData({...formData, name: e.target.value})}
              required
            />
          </div>
          <div className="mb-4">
            <label className="block mb-2">Email</label>
            <input 
              type="email" 
              className="w-full p-2 rounded text-black"
              value={formData.email}
              onChange={(e) => setFormData({...formData, email: e.target.value})}
              required
            />
          </div>
          <div className="mb-4">
            <label className="block mb-2">Password</label>
            <input 
              type="password" 
              className="w-full p-2 rounded text-black"
              value={formData.password}
              onChange={(e) => setFormData({...formData, password: e.target.value})}
              required
            />
          </div>
          <div className="mb-4">
            <label className="block mb-2">Register as:</label>
            <select 
              className="w-full p-2 rounded text-black"
              value={formData.userType}
              onChange={(e) => setFormData({...formData, userType: e.target.value})}
            >
              <option value="driver">Driver</option>
              <option value="client">Client</option>
            </select>
          </div>
          <button type="submit" className="btn-primary w-full">Register</button>
        </form>
      </div>
    </div>
  )
}
