import { Link } from 'react-router-dom'
import { FaHardHat, FaUserCircle, FaSignOutAlt } from 'react-icons/fa'

export default function Header({ user, setUser }) {
  return (
    <header className="bg-white shadow-md">
      <div className="container mx-auto px-4 py-3 flex justify-between items-center">
        <Link to="/" className="flex items-center text-forest-green">
          <FaHardHat className="text-2xl mr-2" />
          <span className="text-xl font-bold">BlueCollar Connect</span>
        </Link>
        
        <nav className="flex items-center space-x-6">
          <Link to="/jobs" className="hover:text-forest-green">Jobs</Link>
          <Link to="/workers" className="hover:text-forest-green">Workers</Link>
          
          {user ? (
            <div className="flex items-center space-x-4">
              <Link to="/profile" className="flex items-center">
                <FaUserCircle className="mr-1" />
                Profile
              </Link>
              <button 
                onClick={() => setUser(null)}
                className="flex items-center text-red-600"
              >
                <FaSignOutAlt className="mr-1" />
                Logout
              </button>
            </div>
          ) : (
            <div className="flex items-center space-x-4">
              <Link to="/login" className="btn bg-forest-green">Login</Link>
              <Link to="/register" className="btn bg-forest-green">Register</Link>
            </div>
          )}
        </nav>
      </div>
    </header>
  )
}
