import { useState } from 'react'
import { useForm } from 'react-hook-form'
import { FaSignInAlt } from 'react-icons/fa'
import axios from 'axios'
import { useNavigate } from 'react-router-dom'

export default function Login({ setUser }) {
  const { register, handleSubmit, formState: { errors } } = useForm()
  const [error, setError] = useState('')
  const navigate = useNavigate()

  const onSubmit = async (data) => {
    try {
      const response = await axios.post('/api/auth/login', data)
      setUser(response.data.user)
      navigate('/profile')
    } catch (err) {
      setError(err.response?.data?.message || 'Login failed')
    }
  }

  return (
    <div className="container mx-auto px-4 py-8 max-w-md">
      <div className="bg-white p-6 rounded-lg shadow-md">
        <h2 className="text-2xl font-bold mb-6 text-forest-green flex items-center">
          <FaSignInAlt className="mr-2" />
          Login
        </h2>
        
        {error && <div className="mb-4 text-red-600">{error}</div>}
        
        <form onSubmit={handleSubmit(onSubmit)}>
          <div className="mb-4">
            <label className="block mb-1">Email</label>
            <input
              type="email"
              {...register('email', { required: 'Email is required' })}
              className="w-full p-2 border rounded"
            />
            {errors.email && <span className="text-red-600 text-sm">{errors.email.message}</span>}
          </div>
          
          <div className="mb-6">
            <label className="block mb-1">Password</label>
            <input
              type="password"
              {...register('password', { required: 'Password is required' })}
              className="w-full p-2 border rounded"
            />
            {errors.password && <span className="text-red-600 text-sm">{errors.password.message}</span>}
          </div>
          
          <button type="submit" className="btn bg-forest-green w-full">
            Login
          </button>
        </form>
        
        <div className="mt-4 text-center">
          <p>Don't have an account? <a href="/register" className="text-forest-green">Register here</a></p>
        </div>
      </div>
    </div>
  )
}
