import { Routes, Route } from 'react-router-dom'
import Home from './pages/Home'
import Assessment from './pages/Assessment'
import Profile from './pages/Profile'
import Coaches from './pages/Coaches'
import Schedule from './pages/Schedule'
import Goals from './pages/Goals'
import Navbar from './components/Navbar'

function App() {
  return (
    <div className="min-h-screen bg-[#f5f5dc]">
      <Navbar />
      <div className="container mx-auto px-4 py-8">
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/assessment" element={<Assessment />} />
          <Route path="/profile" element={<Profile />} />
          <Route path="/coaches" element={<Coaches />} />
          <Route path="/schedule" element={<Schedule />} />
          <Route path="/goals" element={<Goals />} />
        </Routes>
      </div>
    </div>
  )
}

export default App
