import { Link } from 'react-router-dom'

export default function Navbar() {
  return (
    <nav className="bg-saddle-brown text-white p-4 shadow-md">
      <div className="container mx-auto flex justify-between items-center">
        <Link to="/" className="text-xl font-bold">
          CoachingMatch
        </Link>
        <div className="space-x-4">
          <Link to="/assessment" className="hover:underline">
            Assessment
          </Link>
          <Link to="/profile" className="hover:underline">
            Profile
          </Link>
          <Link to="/coaches" className="hover:underline">
            Find Coaches
          </Link>
          <Link to="/schedule" className="hover:underline">
            Schedule
          </Link>
          <Link to="/goals" className="hover:underline">
            Goals
          </Link>
        </div>
      </div>
    </nav>
  )
}
